import sqlite3
import openpyxl
import csv
from openpyxl import Workbook

conn = sqlite3.connect("Small_Customer_Database.db")
c = conn.cursor()

wb = Workbook()
book = Workbook
ws1 = wb.active
# Converting data with all customers to SQL

csv.register_dialect('powercode', quoting=csv.QUOTE_ALL)

# Registers the CSV dialect used by powercode to the CSV reader in Python.

conn = sqlite3.connect("Small_Customer_Database.db")
c = conn.cursor()

# Establishes an internal connection to the database created by the program.

def create_table():

    try:
        c.execute("DROP TABLE customers")

    except:
        pass

    # Dropping the table of customers if one exists already.
    # This allows the data to be overwritten.

    c.execute("CREATE TABLE IF NOT EXISTS customers (customerID INTEGER, customerName TEXT, equipmentName TEXT, deviceType TEXT, parent TEXT, parentID INTEGER, latitude REAL, longitude REAL, plan TEXT)")
    conn.commit()

    # Creates the table 'customers' with the given parameters.

def import_all_cpe_data():

    file = open("Custom Report - All Customer Geocodes.csv", 'r')
    csv_reader = csv.reader(file, dialect='powercode')
    for row in csv_reader:

        tuple_row = (row[0], row[1], row[2], row[3], row[4], row[5], row[6], row[7])
        c.execute("INSERT INTO customers VALUES (?, ?, ?, ?, ?, ?, ?, ?, '')", tuple_row)

    conn.commit()

    # Iterates through the rows of the customer_geocodes CSV files, and adds
    # their information to the program's SQL database. Leaves the last column
    # blank - this is kept open for the customer plans.

def import_plan_data():

    file = open('Custom Report - Customers with Services.csv', 'r')
    csv_reader = csv.reader(file, dialect='powercode')
    customer_plans = []
    previous_id = 0

    for row in csv_reader:

        if "Mbps" in row[2]:

            current_id = int(row[0])

            if current_id == previous_id:
                    previous_id = current_id
            else:
                customer_plans = "\n".join(customer_plans)

                tuple_row = (customer_plans, previous_id)
                c.execute("UPDATE customers SET plan = ? WHERE customerID = ?", tuple_row)

                customer_plans = []
                customer_plans.append(row[2])
                previous_id = current_id
        else:

            pass

    conn.commit()

    # Imports the plan data into the customers table. The program was originally
    # set up to add all plan data to the databse, but this was causing strange
    # issues with openpyxl, so I set it up to only add the speed plan.

def clear_sheet():
    for row in ws1['A1:Z100']:
        for cell in row:
            cell.value = None

try:

    for row in c.execute("SELECT * FROM customers LIMIT 1"):

        print("Previous data detected. To use this data, press enter.\nTo generate new data, enter 'overwrite', then press enter.")

    # Basically, if there is data in the database already, this message will be printed once.

    if input("> "):

        create_table()
        import_all_cpe_data()
        import_plan_data()
    else:
        pass

    # It asks the user to enter 'overwrite'. Really, they could enter anything,
    # and as long as it's not blank, it'll evaluate true, therefore wiping
    # the previous DB and rebuilding itself.
except:

    create_table()
    import_all_cpe_data()
    import_plan_data()

# If finding one row fails, build the DB.
def search_for_towers():
    global tower
    tower = input("Which tower site do you want data for?\n> ")
    tower_sites = []
    for row in c.execute("SELECT parent, parentID FROM customers"):
        if row[0].lower().find(tower.lower()) != -1:
            if row in tower_sites:
                pass
            else:
                tower_sites.append(row)

    return tower_sites

def gen_sheet(tower_site):

    tower_site = (tower_site[0].replace("/", "_"), tower_site[1])
    ws1.title = tower_site[0]

    a = 1

    for row in c.execute("SELECT * FROM customers WHERE parentID = ?", (tower_site[1],)):

        ws1.cell(row=1, column=1).value="Customer ID"
        ws1.cell(row=1, column=2).value="Customer Name"
        ws1.cell(row=1, column=3).value="Equipment ID"
        ws1.cell(row=1, column=4).value="Equipment Type"
        ws1.cell(row=1, column=5).value="Parent AP"
        ws1.cell(row=1, column=6).value="Parent Equipment ID"
        ws1.cell(row=1, column=7).value="Latitude"
        ws1.cell(row=1, column=8).value="Longitude"
        ws1.cell(row=1, column=9).value="Plan"

        # Creates the headers for the excel sheet.

        for i in range(0, 9):

            ws1.cell(row=a, column=(i+1), value=row[i])

            # Iterates throuugh the row of the SQL statement, and adds each item
            # to the spreadsheet.

        a += 1

    wb.save(filename = f"{tower_site[0]}.xlsx")

    # Saves the sheet.
    clear_sheet()

def tower_location():
    global tower
    print("What are the coordinates of the tower site?")
    print("Latitude:")
    latitude = input("> ")
    print("Longitude:")
    longitude = input("> ")

    ws1.title = "Tower Location"
    ws1.cell(row=1, column=1).value="Tower Name"
    ws1.cell(row=1, column=2).value="Latitude"
    ws1.cell(row=1, column=3).value="Longitude"
    ws1.cell(row=2, column=1).value=tower
    ws1.cell(row=2, column=2).value=latitude
    ws1.cell(row=2, column=3).value=longitude
    tower = tower.replace("/", "_")
    wb.save(filename = f"{tower} Tower Site Location.xlsx")

# Creates the tower site location spreadsheet.

tower_sites = search_for_towers()
tower_location()
for tower in tower_sites:
    gen_sheet(tower)
